setwd("<your directory or folder path>")
df1 <- read.csv("20191018 Example 8.2 Balance and Orthogonality.csv")
library(car) #needed to use function Anova() - not the same as anova()
library(lmerTest)
# Variables
# 
# Ex.Unit
# Treatment.RCB
# Treatment.BIB
# Treatment.UNB
# Response.RCB
# Response.BIB
# Response.UNB
#
# For all treament variables:
# If Treatment = 1, Response ~ N(mu=10,sigma=0.67) + Ex.Unit effect
# Else, Response ~ N*mu=5,sigma=0.5) + Ex.Unit effect
#
# The Ex.Unit effect was generated as a normal variable with mean = E.Unit number, and 
# standard deviation = 1/Ex.Unit number.
# The Ex.Unit effect was added to insure that Ex.Unit was significant.
#

#
attach(df1)

f.Unit <- factor(Ex.Unit)
f.RCB <- factor(Treatment.RCB)
f.BIB <- factor(Treatment.BIB)
f.UNB <- factor(Treatment.UNB)
#model.ran <- lmer(Response ~ (1|fSub) + Treat)
model.rcb <- lm(Response.RCB ~ f.Unit + f.RCB -1)
model.bib <- lm(Response.BIB ~ f.Unit + f.BIB -1)
model.unb <- lm(Response.UNB ~ f.Unit + f.UNB -1)

boxplot(Response.RCB ~ Treatment.RCB,main="Boxplot for RCB",xlab="Treatment RCB",ylab="Response")
dev.new()
boxplot(Response.BIB ~ Treatment.BIB,main="Boxplot for BIB",xlab="Treatment BIB",ylab="Response")
dev.new()
boxplot(Response.UNB ~ Treatment.UNB,main="Boxplot for Unbalanced",xlab="Treatment Unbalanced",ylab="Response")

anova.rcb <- Anova(model.rcb,test.statistic="F",type=3)
anova.bib <- Anova(model.bib,test.statistic="F",type=3)
anova.unb <- Anova(model.unb,test.statistic="F",type=3)

anova.rcb
anova.bib
anova.unb

aov.rcb <- aov(Response.RCB ~ f.Unit + f.RCB)
aov.bib <- aov(Response.BIB ~ f.Unit + f.BIB)
aov.unb <- aov(Response.UNB ~ f.Unit + f.UNB)


TukeyHSD(x=aov.rcb,which="f.RCB")
TukeyHSD(x=aov.bib,which="f.BIB")
TukeyHSD(x=aov.unb,which="f.UNB")

#
#
#
mixed.rcb <- lmer(Response.RCB ~ (1|f.Unit) + f.RCB -1)
mixed.bib <- lmer(Response.BIB ~ (1|f.Unit) + f.BIB -1)
mixed.unb <- lmer(Response.UNB ~ (1|f.Unit) + f.UNB -1)

Anova(mixed.rcb,test.statistic="F",type=3)
Anova(mixed.bib,test.statistic="F",type=3)
Anova(mixed.unb,test.statistic="F",type=3)

summary(mixed.rcb)
summary(mixed.bib)
summary(mixed.unb)
